  ' -----------------------------------------------------------
  ' GSR module checkout.bas
  ' A program for Micromite to check out the Seeed/Grove GSR
  ' (Galvanic Skin Response) module.
  '  
  ' Written by Jim Rowe for Silicon Chip.
  ' Last revision 3/1/2019 at 2:40 pm
  '
  ' ----------------------------------------------------------
  
  OPTION AUTORUN ON
  OPTION EXPLICIT
  
  DIM AS INTEGER Sensval = 0    ' sensor module output value (0 - 1024)
  DIM AS INTEGER GSRsum = 0     ' sum of 10 readings
  DIM AS INTEGER GSRavg = 0     ' average of 10 readings
  Dim AS INTEGER Ctr = 0        ' counter used for looping
  
  Const DBlue = RGB(0,0,128)
  CONST Bone = RGB(255,255,192)
  CONST White = RGB(WHITE)
  CONST Black = RGB(BLACK)
  CONST Red = RGB(RED)
  CONST Green = RGB(GREEN)
  
  PIN(24) = 0             ' set pin 24 to low and
  SETPIN 24, AIN         ' declare it an analog input
  ' ----------------------------------------------------------------------
  ' first show the opening screen
  CLS Black
  RBOX 0,0, MM.HRes-2, MM.VRes-2, 5, RGB(Cyan), Black
  TEXT MM.HRes/2, MM.VRes/8, "SILICON CHIP", CM, 1, 3, Red, Black
  TEXT MM.HRes/2, MM.VRes*3/8, "GSR Sensing Module",CM, 1, 2, White, Black
  TEXT MM.HRes/2, MM.VRes/2, "Checkout Program", CM, 1, 2, White, Black
  TEXT MM.HRes/2, MM.VRes*3/4, "Next Reading =", CM, 1, 2, RGB(Cyan), Black
  
  ' main program loop starts here
  DO
    GSRsum = 0
    FOR Ctr = 0 TO 9 STEP 1
      SensVal = CINT(PIN(24) * 200) ' now get the current input voltage (x200)
      GSRsum = GSRsum + SensVal ' add it to the sum
    PAUSE 50           ' set to loop about once every 50ms
    NEXT
    GSRavg = GSRsum/10  ' now get the average of the 10 readings
    PRINT "Reading = ", GSRavg  ' print it out, also show on LCD screen
    TEXT MM.HRes/2, MM.VRes*7/8, STR$(GSRavg), CM, 1, 2, RGB(Cyan), Black
  LOOP
END ' end of main part of program
  
  ' *****************************************************************

